/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.util.IConfigurationElementProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationElementDispatcher
implements IConfigurationElementProcessor {
    private Map<String, IConfigurationElementProcessor> dispatchTable;

    public ConfigurationElementDispatcher() {
    }

    public ConfigurationElementDispatcher(IConfigurationElementProcessor ... processors) {
        if (processors != null) {
            IConfigurationElementProcessor[] iConfigurationElementProcessorArray = processors;
            int n = processors.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElementProcessor processor = iConfigurationElementProcessorArray[n2];
                this.addElementProcessor(processor);
                ++n2;
            }
        }
    }

    public void addElementProcessor(IConfigurationElementProcessor processor) {
        if (processor != null) {
            if (this.dispatchTable == null) {
                this.dispatchTable = new HashMap<String, IConfigurationElementProcessor>();
            }
            for (String elementName : processor.getSupportElementNames()) {
                this.dispatchTable.put(elementName, processor);
            }
        }
    }

    @Override
    public void processElement(IConfigurationElement element) {
        String name = element.getName();
        if (this.dispatchTable != null && this.dispatchTable.containsKey(name)) {
            this.dispatchTable.get(name).processElement(element);
        }
    }

    public void removeElementProcessor(String elementName) {
        if (this.dispatchTable != null && this.dispatchTable.containsKey(elementName)) {
            this.dispatchTable.remove(elementName);
        }
    }

    @Override
    public Set<String> getSupportElementNames() {
        if (this.dispatchTable != null) {
            return this.dispatchTable.keySet();
        }
        return Collections.emptySet();
    }
}

